//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Factory
{
	/// <summary>
	/// Represents a factory that creates named object instances.
	/// </summary>
    public interface INamedObjectFactory<TObjectToCreate> : IObjectFactory<TObjectToCreate, string>
	{
		/// <summary>
		/// When implemented by a class, creates the default object instance.
		/// </summary>
		/// <returns>The default object instance.</returns>
        TObjectToCreate CreateDefault();

		/// <summary>
		/// When implemented by a class, creates the default object instance using the configuration source.
		/// </summary>
		/// <param name="configurationSource">an <see cref="IConfigurationSource"/> object.</param>
		/// <returns>The default object instance.</returns>
        TObjectToCreate CreateDefault(IConfigurationSource configurationSource);
	}
}
